/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.circuitbreaker.LoadAverageCircuitBreaker;
import org.apache.solr.util.circuitbreaker.MemoryCircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.4")
public class CircuitBreakerManager
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean cpuEnabled;
    private boolean memEnabled;
    private int memThreshold = 100;
    private int cpuThreshold = 100;
    private MemoryCircuitBreaker memCB;
    private LoadAverageCircuitBreaker cpuCB;

    @Override
    public boolean isTripped() {
        return this.memEnabled && this.memCB.isTripped() || this.cpuEnabled && this.cpuCB.isTripped();
    }

    @Override
    public String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.memEnabled) {
            sb.append(this.memCB.getErrorMessage());
        }
        if (this.memEnabled && this.cpuEnabled) {
            sb.append("\n");
        }
        if (this.cpuEnabled) {
            sb.append(this.cpuCB.getErrorMessage());
        }
        return sb.toString();
    }

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        log.warn("CircuitBreakerManager is deprecated. Use individual Circuit Breakers instead");
        if (this.memEnabled) {
            this.memCB = new MemoryCircuitBreaker();
            this.memCB.setThreshold(this.memThreshold);
        }
        if (this.cpuEnabled) {
            this.cpuCB = new LoadAverageCircuitBreaker();
            this.cpuCB.setThreshold(this.cpuThreshold);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.memEnabled) {
                this.memCB.close();
            }
        }
        finally {
            if (this.cpuEnabled) {
                this.cpuCB.close();
            }
        }
    }

    public void setMemEnabled(String enabled) {
        this.memEnabled = Boolean.getBoolean(enabled);
    }

    public void setMemThreshold(int threshold) {
        this.memThreshold = threshold;
    }

    public void setMemThreshold(String threshold) {
        this.memThreshold = Integer.parseInt(threshold);
    }

    public void setCpuEnabled(String enabled) {
        this.cpuEnabled = Boolean.getBoolean(enabled);
    }

    public void setCpuThreshold(int threshold) {
        this.cpuThreshold = threshold;
    }

    public void setCpuThreshold(String threshold) {
        this.cpuThreshold = Integer.parseInt(threshold);
    }
}

