/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class MrTree {
    private AlgorithmAssembler<TreeLayoutPhases, TGraph> algorithmAssembler = AlgorithmAssembler.create(TreeLayoutPhases.class);
    private List<ILayoutProcessor<TGraph>> algorithm;

    public TGraph doLayout(TGraph tgraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Tree layout", 1.0f);
        if (tgraph.getProperty(MrTreeOptions.DEBUG_MODE).booleanValue()) {
            progressMonitor.log("MrTree! called at " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }
        this.updateModules(tgraph);
        this.layout(tgraph, progressMonitor.subTask(1.0f));
        progressMonitor.done();
        return tgraph;
    }

    private void updateModules(TGraph graph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase(TreeLayoutPhases.P1_TREEIFICATION, TreeLayoutPhases.P1_TREEIFICATION);
        this.algorithmAssembler.setPhase(TreeLayoutPhases.P2_NODE_ORDERING, TreeLayoutPhases.P2_NODE_ORDERING);
        this.algorithmAssembler.setPhase(TreeLayoutPhases.P3_NODE_PLACEMENT, TreeLayoutPhases.P3_NODE_PLACEMENT);
        this.algorithmAssembler.setPhase(TreeLayoutPhases.P4_EDGE_ROUTING, TreeLayoutPhases.P4_EDGE_ROUTING);
        this.algorithm = this.algorithmAssembler.build(graph);
    }

    private void layout(TGraph graph, IElkProgressMonitor themonitor) {
        IElkProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Layout", this.algorithm.size());
        if (graph.getProperty(MrTreeOptions.DEBUG_MODE).booleanValue()) {
            themonitor.log("ELK MrTree uses the following " + this.algorithm.size() + " modules:");
            int i = 0;
            while (i < this.algorithm.size()) {
                themonitor.log("   Slot " + i + ": " + this.algorithm.get(i).getClass().getName());
                ++i;
            }
        }
        for (ILayoutProcessor<TGraph> processor : this.algorithm) {
            if (monitor.isCanceled()) {
                return;
            }
            processor.process(graph, monitor.subTask(1.0f));
        }
        monitor.done();
    }
}

