/* === This file is part of Calamares - <https://github.com/calamares> ===
 *
 *   Copyright 2015, Teo Mrnjavac <teo@kde.org>
 *   Copyright 2015-2018, Anke Boersma <demm@kaosx.us>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0;
import calamares.slideshow 1.0;

Presentation
{
    id: presentation

    Timer {
        interval: 5000
        running: false
        repeat: true
        onTriggered: presentation.goToNextSlide()
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background
            source: "1.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: -125
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr(".<br/>"+
                    ".<br/>"+
                    "<br/>"+
                    "<br/>"+
                    ".<br/>")
                wrapMode: Text.WordWrap
                width: 500
                horizontalAlignment: Text.AlignLeft
            }
        }
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background1
            source: "2.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: 250
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr(".<br/>"+
                    "<br/>"+
                    "<br/>"+
                    ".<br/>")
                wrapMode: Text.WordWrap
                width: 450
                horizontalAlignment: Text.AlignLeft
            }
        }
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background2
            source: "3.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: -100
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr(".<br/>"+
                    ".<br/>")
                wrapMode: Text.WordWrap
                width: 450
                horizontalAlignment: Text.AlignLeft
            }
        }
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background3
            source: "4.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: 250
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr("<br/>"+
                    "<br/>"+
                    ".<br/>")
                wrapMode: Text.WordWrap
                width: 450
                horizontalAlignment: Text.AlignLeft
            }
        }
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background4
            source: "5.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: -200
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr(".<br/>")
                wrapMode: Text.WordWrap
                width: 450
                horizontalAlignment: Text.Center
            }
        }
    }

    Slide {
        anchors.fill: parent

        Image {
            id: background5
            source: "6.png"
            anchors.fill: parent

            Text {
                anchors.centerIn: parent
                anchors.verticalCenterOffset: 0
                anchors.horizontalCenterOffset: 250
                font.pixelSize: parent.width *.015
                color: 'white'
                text: qsTr(".")
                wrapMode: Text.WordWrap
                width: 450
                horizontalAlignment: Text.Center
            }
        }
    }
}
