/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.plan;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;

public class HANAPlanNode
extends AbstractExecutionPlanNode {
    private HANAPlanNode parentNode;
    private Collection<HANAPlanNode> nestedNodes = new ArrayList<HANAPlanNode>(64);
    private String operatorName;
    private String operatorDetails;
    private String operatorProperties;
    private String executionEngine;
    private String databaseName;
    private String schemaName;
    private String tableName;
    private String tableType;
    private Double tableSize;
    private Double outputSize;
    private Double subtreeCost;
    private int operatorId;
    private int parentOperatorId;
    private String host;
    private int port;
    private Timestamp timestamp;

    public HANAPlanNode(ResultSet dbResult) {
        this.operatorName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OPERATOR_NAME");
        this.operatorDetails = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OPERATOR_DETAILS");
        this.operatorProperties = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OPERATOR_PROPERTIES");
        this.executionEngine = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EXECUTION_ENGINE");
        this.databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATABASE_NAME");
        this.schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA_NAME");
        this.tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        this.tableType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE");
        this.tableSize = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"TABLE_SIZE");
        this.outputSize = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"OUTPUT_SIZE");
        this.subtreeCost = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"SUBTREE_COST");
        this.operatorId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"OPERATOR_ID");
        this.parentOperatorId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARENT_OPERATOR_ID");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HOST");
        this.port = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PORT");
        this.timestamp = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"TIMESTAMP");
    }

    public void addNested(HANAPlanNode node) {
        this.nestedNodes.add(node);
    }

    public void setParent(HANAPlanNode node) {
        this.parentNode = node;
    }

    public DBCPlanNode getParent() {
        return this.parentNode;
    }

    public Collection<HANAPlanNode> getNested() {
        return this.nestedNodes;
    }

    public String getNodeName() {
        return this.operatorName;
    }

    public String getNodeType() {
        return null;
    }

    public String getNodeDescription() {
        return this.operatorDetails;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public int getParentOperatorId() {
        return this.parentOperatorId;
    }

    @Property(order=0, viewable=true)
    public String getOperatorName() {
        return this.operatorName;
    }

    @Property(order=1, viewable=true)
    public String getOperatorDetails() {
        return this.operatorDetails;
    }

    @Property(order=2, viewable=true)
    public String getOperatorProperties() {
        return this.operatorProperties;
    }

    @Property(order=3, viewable=true)
    public String getExecutionEngine() {
        return this.executionEngine;
    }

    @Property(order=4, viewable=true)
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Property(order=5, viewable=true)
    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(order=6, viewable=true)
    public String getTableName() {
        return this.tableName;
    }

    @Property(order=7, viewable=true)
    public String getTableType() {
        return this.tableType;
    }

    @Property(order=8, viewable=true)
    public Double getTableSize() {
        return this.tableSize;
    }

    @Property(order=9, viewable=true)
    public Double getOutputSize() {
        return this.outputSize;
    }

    @Property(order=10, viewable=true)
    public Double getSubtreeCost() {
        return this.subtreeCost;
    }

    @Property(order=11, viewable=true)
    public String getHost() {
        return this.host;
    }

    @Property(order=12, viewable=true)
    public int getPort() {
        return this.port;
    }

    @Property(order=13, viewable=true)
    public Timestamp getTimestamp() {
        return this.timestamp;
    }
}

